import { View, Dimensions, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { relatedItemStyle } from "../../../../screens/Home/FeaturedProducts/ProductDetails/RelatedItem/relatedItemStyle";
const { width } = Dimensions.get("window");

const RenderItem = ({ item }) => {
    return (
        <View style={relatedItemStyle.imgCont}>
            <SkeletonElement wrapperStyle={styles.wrapperStyle} />
        </View>
    );
};

const PopularProductsSkeleton = () => {
    return (
        <FlatList
            data={[1, 2, 3, 4, 5]}
            renderItem={({ item }) => <RenderItem item={item} />}
            keyExtractor={(_, i) => "key" + i}
            listKey={(_, i) => `listKey-b${i}`}
            horizontal
            showsHorizontalScrollIndicator={false}
        />
    );
};

export default PopularProductsSkeleton;

const styles = StyleSheet.create({
    itemCont: {
        marginTop: dpr(10),
    },
    wrapperStyle: {
        height: dpr(105),
        width: dpr(100),
    }
});
